/* The following code was generated by JFlex 1.4.3 on 8/26/14 9:37 AM */

// $codepro.audit.disable
/**
 * Aptana Studio
 * Copyright (c) 2005-2013 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the GNU Public License (GPL) v3 (with exceptions).
 * Please see the license.html included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
package com.aptana.css.core.parsing;

import java.io.Reader;
import java.io.StringReader;

import java.util.ArrayList;
import java.util.List;

import beaver.Symbol;
import beaver.Scanner;

@SuppressWarnings({"unused", "nls"})


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 8/26/14 9:37 AM from the specification file
 * <tt>/Users/cwilliams/repos/studio3/plugins/com.aptana.css.core/parsing/CSS.flex</tt>
 */
class CSSFlexScanner extends Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\23\1\25\1\0\1\3\1\24\22\0\1\23\1\50\1\5"+
    "\1\42\1\55\1\41\1\0\1\6\1\61\1\62\1\10\1\22\1\65"+
    "\1\11\1\21\1\7\12\1\1\20\1\56\1\0\1\52\1\66\1\0"+
    "\1\43\1\34\1\4\1\33\1\17\1\30\1\44\1\15\1\36\1\16"+
    "\1\4\1\40\1\67\1\31\1\26\1\14\1\12\1\4\1\13\1\35"+
    "\1\27\1\45\1\46\1\47\1\32\1\4\1\37\1\63\1\2\1\64"+
    "\1\54\1\4\1\0\1\34\1\4\1\33\1\17\1\30\1\44\1\15"+
    "\1\36\1\16\1\4\1\40\1\67\1\31\1\26\1\14\1\12\1\4"+
    "\1\13\1\35\1\27\1\45\1\46\1\47\1\32\1\4\1\37\1\57"+
    "\1\53\1\60\1\51\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\1\1\3\1\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\4\1\12\1\1\1\13\1\4"+
    "\1\14\2\1\1\4\2\1\1\15\3\1\1\16\1\17"+
    "\1\20\1\21\1\22\1\23\1\24\1\25\1\26\1\0"+
    "\5\4\1\0\3\4\1\27\2\4\2\5\2\6\1\0"+
    "\1\4\1\2\1\0\1\30\1\2\1\4\1\31\1\0"+
    "\1\32\1\0\7\32\1\4\3\0\1\33\1\34\1\35"+
    "\1\36\1\37\2\4\1\2\1\40\1\41\1\42\1\5"+
    "\1\6\1\0\1\4\10\30\1\27\2\30\10\0\1\27"+
    "\2\0\1\43\7\32\1\4\2\0\1\44\1\45\1\4"+
    "\1\37\2\30\1\40\1\41\1\42\1\37\2\0\1\40"+
    "\1\41\1\42\10\32\3\0\1\4\2\44\2\32\1\46"+
    "\5\32\1\47\1\0\1\4\4\32\1\50\2\32\2\0"+
    "\2\32\1\51\3\32\1\0\1\4\1\0\3\32\1\52"+
    "\1\32\1\0\4\32\1\0\2\32\1\53\1\54\1\55"+
    "\5\32\1\56\1\57";

  private static int [] zzUnpackAction() {
    int [] result = new int[203];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\70\0\160\0\250\0\340\0\u0118\0\u0150\0\u0188"+
    "\0\u01c0\0\70\0\u01f8\0\u0230\0\70\0\u0268\0\u02a0\0\u02d8"+
    "\0\70\0\u0310\0\u0348\0\u0380\0\u03b8\0\u03f0\0\70\0\u0428"+
    "\0\u0460\0\u0498\0\70\0\70\0\70\0\70\0\70\0\70"+
    "\0\70\0\70\0\70\0\250\0\u04d0\0\u0508\0\u0540\0\u0578"+
    "\0\u05b0\0\u05e8\0\u0620\0\u0658\0\u0690\0\u0118\0\u06c8\0\u0700"+
    "\0\u0738\0\70\0\u0770\0\70\0\u07a8\0\u07e0\0\u0818\0\u0850"+
    "\0\u0888\0\u08c0\0\u08f8\0\u0310\0\u0930\0\u0968\0\u09a0\0\u09d8"+
    "\0\u0a10\0\u0a48\0\u0a80\0\u0ab8\0\u0af0\0\u0b28\0\u0b60\0\u03b8"+
    "\0\u0b98\0\u0bd0\0\70\0\70\0\70\0\70\0\u0118\0\u0c08"+
    "\0\u0c40\0\u0c78\0\u0118\0\u0118\0\u0118\0\u0cb0\0\u0ce8\0\u0d20"+
    "\0\u0d58\0\u0d90\0\u0dc8\0\u0e00\0\u0e38\0\u0e70\0\u0ea8\0\u0ee0"+
    "\0\u0f18\0\u0888\0\u0f50\0\u0f88\0\u0fc0\0\u0ff8\0\u1030\0\u1068"+
    "\0\u10a0\0\u10d8\0\u1110\0\u1148\0\70\0\u1180\0\u11b8\0\u0118"+
    "\0\u11f0\0\u1228\0\u1260\0\u1298\0\u12d0\0\u1308\0\u1340\0\u1378"+
    "\0\u13b0\0\u13e8\0\u0118\0\70\0\u1420\0\u0888\0\u1458\0\u1490"+
    "\0\u0888\0\u0888\0\u0888\0\70\0\u14c8\0\u1500\0\70\0\70"+
    "\0\70\0\u1538\0\u1570\0\u15a8\0\u15e0\0\u1618\0\u1650\0\u1688"+
    "\0\u16c0\0\u16f8\0\u1730\0\u1768\0\u17a0\0\u0888\0\70\0\u17d8"+
    "\0\u1810\0\u0968\0\u1848\0\u1880\0\u18b8\0\u18f0\0\u1928\0\70"+
    "\0\u1960\0\u1998\0\u19d0\0\u1a08\0\u1a40\0\u1a78\0\u0968\0\u1ab0"+
    "\0\u1ae8\0\u1b20\0\u1b58\0\u1b90\0\u1bc8\0\u0968\0\u1c00\0\u1c38"+
    "\0\u1c70\0\u1ca8\0\u1ce0\0\u1d18\0\u1d50\0\u1d88\0\u1dc0\0\u0968"+
    "\0\u1df8\0\u1e30\0\u1e68\0\u1ea0\0\u1ed8\0\u1f10\0\u1f48\0\u1f80"+
    "\0\u1fb8\0\u0968\0\u0968\0\70\0\u1ff0\0\u2028\0\u2060\0\u2098"+
    "\0\u20d0\0\u0968\0\u0968";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[203];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\14\5\6\1\15\1\16\1\17\3\5"+
    "\1\20\12\6\1\21\1\22\1\23\1\6\1\24\2\6"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\6"+
    "\71\0\1\3\1\44\1\0\1\6\4\0\1\6\1\45"+
    "\1\46\1\6\1\47\1\50\1\51\1\0\1\52\4\0"+
    "\2\6\1\53\1\54\1\6\1\55\1\6\1\56\1\57"+
    "\1\6\1\60\1\21\2\0\4\6\17\0\4\6\1\0"+
    "\20\6\2\0\42\6\3\0\1\5\17\0\3\5\43\0"+
    "\1\6\1\44\1\0\1\6\4\0\7\6\6\0\13\6"+
    "\3\0\4\6\17\0\1\6\2\7\1\61\1\0\1\7"+
    "\1\62\16\7\2\0\42\7\2\10\1\63\1\0\2\10"+
    "\1\64\15\10\2\0\42\10\10\0\1\65\60\0\1\3"+
    "\1\44\1\0\1\6\4\0\7\6\1\0\1\52\4\0"+
    "\13\6\3\0\4\6\17\0\1\6\1\0\1\6\1\44"+
    "\1\0\1\6\4\0\2\6\1\66\4\6\6\0\13\6"+
    "\3\0\4\6\17\0\1\6\1\0\1\67\1\70\1\0"+
    "\1\71\4\0\7\71\6\0\13\71\3\0\4\71\17\0"+
    "\1\71\1\0\1\72\17\0\1\52\47\0\1\6\1\44"+
    "\1\0\1\6\4\0\3\6\1\73\3\6\6\0\13\6"+
    "\3\0\4\6\17\0\1\6\1\0\1\74\1\75\1\0"+
    "\1\74\4\0\7\74\6\0\13\74\3\0\4\74\17\0"+
    "\1\74\1\0\1\76\1\77\1\0\1\76\4\0\1\100"+
    "\1\101\3\76\1\102\1\76\6\0\1\103\2\76\1\104"+
    "\1\76\1\105\5\76\3\0\1\106\3\76\17\0\1\76"+
    "\1\0\1\6\1\44\1\0\1\6\4\0\2\6\1\107"+
    "\4\6\6\0\13\6\3\0\4\6\17\0\1\6\3\0"+
    "\1\110\3\0\1\111\6\0\1\112\4\0\3\110\114\0"+
    "\1\113\67\0\1\114\67\0\1\115\67\0\1\116\16\0"+
    "\1\6\1\44\1\0\1\6\4\0\7\6\6\0\1\6"+
    "\1\117\2\6\2\117\5\6\3\0\4\6\17\0\1\6"+
    "\1\0\1\6\1\44\1\0\1\6\4\0\7\6\6\0"+
    "\6\6\1\120\4\6\3\0\4\6\17\0\1\6\1\0"+
    "\1\6\1\44\1\0\1\6\4\0\2\6\1\46\4\6"+
    "\6\0\13\6\3\0\4\6\17\0\1\6\1\0\1\6"+
    "\1\44\1\0\1\6\4\0\7\6\6\0\1\117\12\6"+
    "\3\0\4\6\17\0\1\6\1\0\1\6\1\44\1\0"+
    "\1\6\4\0\7\6\6\0\2\6\1\121\10\6\3\0"+
    "\4\6\17\0\1\6\1\0\1\122\67\0\1\6\1\44"+
    "\1\0\1\6\4\0\7\6\6\0\3\6\1\123\1\124"+
    "\6\6\3\0\4\6\17\0\1\6\1\0\1\6\1\44"+
    "\1\0\1\6\4\0\7\6\6\0\3\6\1\117\3\6"+
    "\1\56\3\6\3\0\4\6\17\0\1\6\1\0\1\6"+
    "\1\44\1\0\1\6\4\0\7\6\6\0\3\6\1\117"+
    "\7\6\3\0\4\6\17\0\1\6\1\0\1\6\1\44"+
    "\1\0\1\6\4\0\7\6\6\0\11\6\1\125\1\6"+
    "\3\0\4\6\17\0\1\6\1\0\1\6\1\44\1\0"+
    "\1\6\4\0\7\6\6\0\10\6\1\57\2\6\3\0"+
    "\4\6\17\0\1\6\2\7\1\61\21\7\1\126\43\7"+
    "\2\10\1\63\21\10\1\127\43\10\10\65\1\130\57\65"+
    "\1\0\1\6\1\44\1\0\1\6\4\0\3\6\1\131"+
    "\3\6\6\0\13\6\3\0\4\6\17\0\1\6\1\0"+
    "\1\67\1\70\1\0\1\71\4\0\1\71\1\132\1\133"+
    "\1\71\1\134\1\135\1\136\6\0\2\71\1\137\1\140"+
    "\1\71\1\141\1\71\1\142\1\143\1\71\1\144\1\21"+
    "\2\0\4\71\17\0\4\71\1\0\20\71\2\0\42\71"+
    "\1\0\1\71\1\70\1\0\1\71\4\0\7\71\6\0"+
    "\13\71\3\0\4\71\17\0\1\71\1\0\1\72\10\0"+
    "\1\145\1\146\1\0\1\147\1\150\1\151\1\0\1\52"+
    "\6\0\1\152\1\153\1\0\1\154\1\0\1\155\1\156"+
    "\1\0\1\157\1\21\27\0\1\6\1\44\1\0\1\6"+
    "\4\0\7\6\6\0\1\6\1\160\11\6\3\0\4\6"+
    "\17\0\1\6\3\74\1\0\20\74\2\0\42\74\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\13\76"+
    "\3\0\4\76\17\0\4\76\1\0\20\76\2\0\42\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\3\76\1\161\7\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\6\76"+
    "\1\162\4\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\7\76\6\0\3\76\1\163"+
    "\7\76\3\0\4\76\17\0\1\76\1\0\1\76\1\77"+
    "\1\0\1\76\4\0\7\76\6\0\6\76\1\164\4\76"+
    "\3\0\4\76\17\0\1\76\1\0\1\76\1\77\1\0"+
    "\1\76\4\0\7\76\6\0\2\76\1\165\10\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\7\76\6\0\10\76\1\166\2\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\3\76\1\167\3\76\6\0\13\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\6\1\44\1\0\1\6\4\0\7\6"+
    "\6\0\13\6\3\0\4\6\17\0\1\170\10\0\1\171"+
    "\110\0\1\172\37\0\1\6\1\44\1\0\1\6\4\0"+
    "\6\6\1\173\6\0\13\6\3\0\4\6\17\0\1\6"+
    "\1\0\1\6\1\44\1\0\1\6\4\0\4\6\1\173"+
    "\2\6\6\0\13\6\3\0\4\6\17\0\1\6\1\0"+
    "\1\122\10\0\1\145\1\146\1\0\1\147\1\150\1\151"+
    "\10\0\1\152\1\153\1\0\1\154\1\0\1\155\1\156"+
    "\1\0\1\157\1\21\26\0\2\7\1\61\1\0\1\7"+
    "\1\62\16\7\1\0\43\7\2\10\1\63\1\0\2\10"+
    "\1\64\15\10\1\0\43\10\7\65\1\174\1\130\57\65"+
    "\1\0\1\6\1\44\1\0\1\6\4\0\4\6\1\175"+
    "\2\6\6\0\13\6\3\0\4\6\17\0\1\6\1\0"+
    "\1\71\1\70\1\0\1\71\4\0\7\71\6\0\1\71"+
    "\1\176\2\71\2\176\5\71\3\0\4\71\17\0\1\71"+
    "\1\0\1\71\1\70\1\0\1\71\4\0\7\71\6\0"+
    "\6\71\1\177\4\71\3\0\4\71\17\0\1\71\1\0"+
    "\1\71\1\70\1\0\1\71\4\0\2\71\1\133\4\71"+
    "\6\0\13\71\3\0\4\71\17\0\1\71\1\0\1\71"+
    "\1\70\1\0\1\71\4\0\7\71\6\0\1\176\12\71"+
    "\3\0\4\71\17\0\1\71\1\0\1\71\1\70\1\0"+
    "\1\71\4\0\7\71\6\0\2\71\1\200\10\71\3\0"+
    "\4\71\17\0\1\71\1\0\1\71\1\70\1\0\1\71"+
    "\4\0\7\71\6\0\3\71\1\201\1\202\6\71\3\0"+
    "\4\71\17\0\1\71\1\0\1\71\1\70\1\0\1\71"+
    "\4\0\7\71\6\0\3\71\1\176\3\71\1\142\3\71"+
    "\3\0\4\71\17\0\1\71\1\0\1\71\1\70\1\0"+
    "\1\71\4\0\7\71\6\0\3\71\1\176\7\71\3\0"+
    "\4\71\17\0\1\71\1\0\1\71\1\70\1\0\1\71"+
    "\4\0\7\71\6\0\11\71\1\203\1\71\3\0\4\71"+
    "\17\0\1\71\1\0\1\71\1\70\1\0\1\71\4\0"+
    "\7\71\6\0\10\71\1\143\2\71\3\0\4\71\17\0"+
    "\1\71\27\0\1\204\2\0\2\204\70\0\1\205\46\0"+
    "\1\146\102\0\1\204\71\0\1\206\70\0\1\207\1\210"+
    "\66\0\1\204\3\0\1\155\63\0\1\204\75\0\1\211"+
    "\66\0\1\156\32\0\1\76\1\77\1\0\1\76\4\0"+
    "\3\76\1\212\3\76\6\0\7\76\1\213\3\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\4\76\1\214\2\76\6\0\13\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\1\76\1\215\5\76\6\0\13\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\76\1\77\1\0\1\76\4\0\7\76"+
    "\6\0\3\76\1\216\7\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\6\76\1\217"+
    "\6\0\13\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\7\76\6\0\6\76\1\220"+
    "\4\76\3\0\4\76\17\0\1\76\1\0\1\76\1\77"+
    "\1\0\1\76\4\0\7\76\6\0\1\221\12\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\6\1\44\1\0\1\6"+
    "\4\0\7\6\6\0\13\6\3\0\4\6\11\0\1\222"+
    "\5\0\1\6\10\171\1\223\57\171\12\0\1\224\56\0"+
    "\1\6\1\44\1\0\1\6\4\0\5\6\1\225\1\6"+
    "\6\0\13\6\3\0\4\6\17\0\1\6\1\0\1\71"+
    "\1\70\1\0\1\71\4\0\6\71\1\226\6\0\13\71"+
    "\3\0\4\71\17\0\1\71\1\0\1\71\1\70\1\0"+
    "\1\71\4\0\4\71\1\226\2\71\6\0\13\71\3\0"+
    "\4\71\17\0\1\71\17\0\1\227\65\0\1\227\53\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\11\76"+
    "\1\230\1\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\1\231\6\76\6\0\13\76"+
    "\3\0\4\76\17\0\1\76\1\0\1\76\1\77\1\0"+
    "\1\76\4\0\7\76\6\0\2\76\1\232\10\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\3\76\1\233\3\76\6\0\13\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\7\76\6\0\2\76\1\234\10\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\76\1\77\1\0\1\76\4\0\5\76"+
    "\1\235\1\76\6\0\13\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\2\76\1\236"+
    "\4\76\6\0\13\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\1\76"+
    "\1\237\11\76\3\0\4\76\17\0\1\76\62\222\1\240"+
    "\5\222\7\171\1\110\1\223\57\171\14\0\1\241\54\0"+
    "\1\6\1\44\1\0\1\6\4\0\6\6\1\242\6\0"+
    "\13\6\3\0\4\6\17\0\1\6\1\0\1\76\1\77"+
    "\1\0\1\76\4\0\1\243\6\76\6\0\13\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\7\76\6\0\13\76\3\0\2\76\1\244\1\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\2\76\1\245\4\76\6\0\13\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\76\1\77\1\0\1\76\4\0\7\76"+
    "\6\0\7\76\1\246\3\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\6\76\1\247\4\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\7\76"+
    "\1\250\3\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\1\251\6\76\6\0\13\76"+
    "\3\0\4\76\17\0\1\76\13\0\1\252\55\0\1\6"+
    "\1\44\1\0\1\6\4\0\7\6\1\253\5\0\13\6"+
    "\3\0\4\6\17\0\1\6\1\0\1\76\1\77\1\0"+
    "\1\76\4\0\6\76\1\254\6\0\13\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\5\76\1\255\1\76\6\0\13\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\76\1\77\1\0\1\76\4\0\7\76"+
    "\6\0\1\76\1\256\11\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\1\76\1\257"+
    "\5\76\6\0\13\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\2\76"+
    "\1\260\10\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\7\76\6\0\13\76\3\0"+
    "\1\261\3\76\17\0\1\76\27\0\1\262\41\0\1\263"+
    "\1\264\1\0\1\263\4\0\7\263\6\0\13\263\3\0"+
    "\4\263\17\0\1\263\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\3\76\1\265\3\76\6\0\13\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\7\76\6\0\2\76\1\266\10\76\3\0\4\76\17\0"+
    "\1\76\1\0\1\76\1\77\1\0\1\76\4\0\7\76"+
    "\6\0\6\76\1\267\4\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\1\76\1\270\11\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\6\76"+
    "\1\271\4\76\3\0\4\76\17\0\1\76\34\0\1\272"+
    "\34\0\1\263\1\264\1\0\1\263\4\0\7\263\1\0"+
    "\1\253\4\0\13\263\3\0\4\263\17\0\4\263\1\0"+
    "\20\263\2\0\42\263\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\7\76\6\0\5\76\1\273\5\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\7\76\6\0\13\76\3\0\3\76\1\274\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\5\76\1\275\5\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\5\76"+
    "\1\276\5\76\3\0\4\76\17\0\1\76\26\0\1\277"+
    "\42\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\13\76\3\0\1\76\1\300\2\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\1\76\1\301\5\76"+
    "\6\0\13\76\3\0\4\76\17\0\1\76\1\0\1\76"+
    "\1\77\1\0\1\76\4\0\7\76\6\0\2\76\1\302"+
    "\10\76\3\0\4\76\17\0\1\76\1\0\1\76\1\77"+
    "\1\0\1\76\4\0\7\76\6\0\2\76\1\303\10\76"+
    "\3\0\4\76\17\0\1\76\27\0\1\304\41\0\1\76"+
    "\1\77\1\0\1\76\4\0\7\76\6\0\3\76\1\305"+
    "\7\76\3\0\4\76\17\0\1\76\1\0\1\76\1\77"+
    "\1\0\1\76\4\0\3\76\1\306\3\76\6\0\13\76"+
    "\3\0\4\76\17\0\1\76\1\0\1\76\1\77\1\0"+
    "\1\76\4\0\7\76\6\0\2\76\1\307\10\76\3\0"+
    "\4\76\17\0\1\76\1\0\1\76\1\77\1\0\1\76"+
    "\4\0\2\76\1\310\4\76\6\0\13\76\3\0\4\76"+
    "\17\0\1\76\1\0\1\76\1\77\1\0\1\76\4\0"+
    "\7\76\6\0\1\311\12\76\3\0\4\76\17\0\1\76"+
    "\1\0\1\76\1\77\1\0\1\76\4\0\7\76\6\0"+
    "\1\76\1\312\11\76\3\0\4\76\17\0\1\76\1\0"+
    "\1\76\1\77\1\0\1\76\4\0\7\76\6\0\1\76"+
    "\1\313\11\76\3\0\4\76\17\0\1\76";

  private static int [] zzUnpackTrans() {
    int [] result = new int[8456];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\7\1\1\11\2\1\1\11\3\1\1\11"+
    "\5\1\1\11\3\1\11\11\1\0\5\1\1\0\7\1"+
    "\1\11\1\1\1\11\1\0\2\1\1\0\4\1\1\0"+
    "\1\1\1\0\10\1\3\0\4\11\11\1\1\0\14\1"+
    "\10\0\1\11\2\0\11\1\2\0\1\1\1\11\7\1"+
    "\1\11\2\0\3\11\10\1\3\0\2\1\1\11\10\1"+
    "\1\11\1\0\10\1\2\0\6\1\1\0\1\1\1\0"+
    "\5\1\1\0\4\1\1\0\4\1\1\11\7\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[203];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	// last token used for look behind. Also needed when implementing the ITokenScanner interface
	private Symbol _lastToken;

	// flag indicating if we should collect comments or not
	private boolean _collectComments = true;

	// comment collections, by type
	private List<Symbol> _comments = new ArrayList<Symbol>();

	// curly brace nesting level
	private int _nestingLevel;

	// a flag indicating we're inside of a @media block
	private boolean _inMedia;

	public CSSFlexScanner()
	{
		this((Reader) null);
	}

	public Symbol getLastToken()
	{
		return _lastToken;
	}

	public List<Symbol> getComments()
	{
		return _comments;
	}

	private Symbol newToken(CSSTokenType type, Object value)
	{
		return newToken(type.getIndex(), value);
	}

	private Symbol newToken(short id, Object value)
	{
		return new Symbol(id, yychar, yychar + yylength() - 1, value);
	}

	public Symbol nextToken() throws java.io.IOException, Scanner.Exception
	{
		try
		{
			// get next token
			_lastToken = yylex();
		} 
		catch (Scanner.Exception e)
		{
			// create default token type
			String text = yytext();
			int end = yychar + text.length() - 1;

			_lastToken = new Symbol(CSSTokenType.EOF.getIndex(), yychar, end, text);
		}

		return _lastToken;
	}

	public void setCollectComments(boolean flag)
	{
		_collectComments = flag;
	}

	public void setSource(String source)
	{
		yyreset(new StringReader(source));

		// clear last token
		_lastToken = null;

		// reset comment collection list
		_comments.clear();

		// reset nesting level
		_nestingLevel = 0;

		// reset media flag
		_inMedia = false;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  CSSFlexScanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  CSSFlexScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 188) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Symbol yylex() throws java.io.IOException, Scanner.Exception {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 3: 
          { /* ignore */
          }
        case 48: break;
        case 4: 
          { return newToken(CSSTokenType.IDENTIFIER, yytext());
          }
        case 49: break;
        case 35: 
          { return newToken(CSSTokenType.NOT, yytext());
          }
        case 50: break;
        case 11: 
          { return newToken(CSSTokenType.PLUS, yytext());
          }
        case 51: break;
        case 29: 
          { return newToken(CSSTokenType.BEGINS_WITH, yytext());
          }
        case 52: break;
        case 9: 
          { return newToken(CSSTokenType.MINUS, yytext());
          }
        case 53: break;
        case 28: 
          { return newToken(CSSTokenType.DASHMATCH, yytext());
          }
        case 54: break;
        case 5: 
          { return newToken(CSSTokenType.DOUBLE_QUOTED_STRING, yytext());
          }
        case 55: break;
        case 25: 
          { CSSTokenType type;

									if ((_inMedia && _nestingLevel == 1) || _nestingLevel <= 0)
									{
										type = CSSTokenType.ID;
									}
									else
									{
										boolean numbers = true;
										String text = yytext();

										for (int i = 1; i < text.length(); i++)
										{
											char c = text.charAt(i);

											if (!('0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F'))
											{
												numbers = false;
												break;
											}
										}

										type = (numbers) ? CSSTokenType.RGB : CSSTokenType.ID;
									}

									return newToken(type, yytext());
          }
        case 56: break;
        case 2: 
          { return newToken(CSSTokenType.NUMBER, yytext());
          }
        case 57: break;
        case 42: 
          { return newToken(CSSTokenType.CHARSET, yytext());
          }
        case 58: break;
        case 13: 
          { return newToken(CSSTokenType.EQUAL, yytext());
          }
        case 59: break;
        case 43: 
          { return newToken(CSSTokenType.NAMESPACE, yytext());
          }
        case 60: break;
        case 38: 
          { return newToken(CSSTokenType.PAGE, yytext());
          }
        case 61: break;
        case 40: 
          { _inMedia = true; return newToken(CSSTokenType.MEDIA_KEYWORD, yytext());
          }
        case 62: break;
        case 27: 
          { return newToken(CSSTokenType.INCLUDES, yytext());
          }
        case 63: break;
        case 47: 
          { return newToken(CSSTokenType.MOZ_DOCUMENT, yytext());
          }
        case 64: break;
        case 16: 
          { _nestingLevel--;

									if (_nestingLevel == 0)
									{
										// reset (possibly set) media flag
										_inMedia = false;
									}

									return newToken(CSSTokenType.RCURLY, yytext());
          }
        case 65: break;
        case 30: 
          { return newToken(CSSTokenType.ENDS_WITH, yytext());
          }
        case 66: break;
        case 46: 
          { return newToken(CSSTokenType.MS_VIEWPORT, yytext());
          }
        case 67: break;
        case 32: 
          { return newToken(CSSTokenType.EMS, yytext());
          }
        case 68: break;
        case 33: 
          { return newToken(CSSTokenType.EXS, yytext());
          }
        case 69: break;
        case 23: 
          { return newToken(CSSTokenType.TIME, yytext());
          }
        case 70: break;
        case 6: 
          { return newToken(CSSTokenType.SINGLE_QUOTED_STRING, yytext());
          }
        case 71: break;
        case 41: 
          { return newToken(CSSTokenType.IMPORT, yytext());
          }
        case 72: break;
        case 15: 
          { _nestingLevel++;

									return newToken(CSSTokenType.LCURLY, yytext());
          }
        case 73: break;
        case 12: 
          { return newToken(CSSTokenType.PERCENTAGE, yytext());
          }
        case 74: break;
        case 18: 
          { return newToken(CSSTokenType.RPAREN, yytext());
          }
        case 75: break;
        case 14: 
          { return newToken(CSSTokenType.SEMICOLON, yytext());
          }
        case 76: break;
        case 24: 
          { CSSTokenType type;

									if ((_inMedia && _nestingLevel == 1) || _nestingLevel <= 0)
									{
										type = CSSTokenType.CLASS;
									}
									else
									{
										boolean numbers = true;
										String text = yytext();

										for (int i = 1; i < text.length(); i++)
										{
											char c = text.charAt(i);

											if (c < '0' || '9' < c)
											{
												numbers = false;
												break;
											}
										}

										type = (numbers) ? CSSTokenType.NUMBER : CSSTokenType.CLASS;
									}

									return newToken(type, yytext());
          }
        case 77: break;
        case 8: 
          { return newToken(CSSTokenType.STAR, yytext());
          }
        case 78: break;
        case 34: 
          { return newToken(CSSTokenType.FREQUENCY, yytext());
          }
        case 79: break;
        case 7: 
          { return newToken(CSSTokenType.SLASH, yytext());
          }
        case 80: break;
        case 37: 
          { _comments.add(newToken(CSSTokenType.COMMENT, yytext()));
          }
        case 81: break;
        case 19: 
          { return newToken(CSSTokenType.LBRACKET, yytext());
          }
        case 82: break;
        case 31: 
          { return newToken(CSSTokenType.LENGTH, yytext());
          }
        case 83: break;
        case 36: 
          { return newToken(CSSTokenType.ANGLE, yytext());
          }
        case 84: break;
        case 26: 
          { return newToken(CSSTokenType.AT_RULE, yytext());
          }
        case 85: break;
        case 1: 
          { return newToken(CSSTokenType.ERROR, yytext());
          }
        case 86: break;
        case 44: 
          { return newToken(CSSTokenType.FONTFACE, yytext());
          }
        case 87: break;
        case 17: 
          { return newToken(CSSTokenType.LPAREN, yytext());
          }
        case 88: break;
        case 45: 
          { return newToken(CSSTokenType.IMPORTANT, yytext());
          }
        case 89: break;
        case 10: 
          { return newToken(CSSTokenType.COLON, yytext());
          }
        case 90: break;
        case 39: 
          { return newToken(CSSTokenType.URL, yytext());
          }
        case 91: break;
        case 21: 
          { return newToken(CSSTokenType.COMMA, yytext());
          }
        case 92: break;
        case 22: 
          { return newToken(CSSTokenType.GREATER, yytext());
          }
        case 93: break;
        case 20: 
          { return newToken(CSSTokenType.RBRACKET, yytext());
          }
        case 94: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              { 	return newToken(Terminals.EOF, "end-of-file");
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
